/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.gui;

import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.client.gui.screen.edit.ContainerEditorScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.PlayerEditorScreen;
import dev.terminalmc.clientsort.client.gui.screen.edit.SelectorScreen;
import dev.terminalmc.clientsort.client.gui.widget.SortButton;
import dev.terminalmc.clientsort.client.gui.widget.StackFillButton;
import dev.terminalmc.clientsort.client.gui.widget.TransferButton;
import dev.terminalmc.clientsort.client.gui.widget.TriggerButton;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.inventory.util.Scope;
import dev.terminalmc.clientsort.client.util.PolicyManager;
import dev.terminalmc.clientsort.mixin.client.accessor.ScreenAccessor;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

public class TriggerButtonManager {
    private static final int BUTTON_SPACING = 1;
    private static final int BUTTON_SHIFT_X = 0;
    private static final int BUTTON_SHIFT_Y = 1;
    private static final LinkedHashSet<TriggerButton> containerButtons = new LinkedHashSet();
    private static final LinkedHashSet<TriggerButton> playerButtons = new LinkedHashSet();

    private TriggerButtonManager() {
    }

    public static LinkedList<TriggerButton> getContainerButtons() {
        return new LinkedList<TriggerButton>(containerButtons);
    }

    public static LinkedList<TriggerButton> getPlayerButtons() {
        return new LinkedList<TriggerButton>(playerButtons);
    }

    public static void afterScreenInit(Screen screen) {
        Slot playerRefSlot;
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen acs = (AbstractContainerScreen)screen;
        containerButtons.clear();
        playerButtons.clear();
        if (!Config.options().showButtons) {
            return;
        }
        boolean forceShowContainer = false;
        boolean forceShowPlayer = false;
        Screen currentScreen = Minecraft.getInstance().screen;
        if (currentScreen instanceof SelectorScreen) {
            forceShowContainer = true;
            forceShowPlayer = true;
        } else if (currentScreen instanceof ContainerEditorScreen) {
            forceShowContainer = true;
        } else if (currentScreen instanceof PlayerEditorScreen) {
            forceShowPlayer = true;
        }
        Slot containerRefSlot = TriggerButtonManager.getReferenceSlot(acs, false);
        if (containerRefSlot != null) {
            TriggerButtonManager.generate(acs, containerRefSlot, false, forceShowContainer, Config.options().firstButtonOp);
            TriggerButtonManager.generate(acs, containerRefSlot, false, forceShowContainer, Config.options().secondButtonOp);
            TriggerButtonManager.generate(acs, containerRefSlot, false, forceShowContainer, Config.options().thirdButtonOp);
        }
        if ((playerRefSlot = TriggerButtonManager.getReferenceSlot(acs, true)) != null) {
            TriggerButtonManager.generate(acs, playerRefSlot, true, forceShowPlayer, Config.options().firstButtonOp);
            TriggerButtonManager.generate(acs, playerRefSlot, true, forceShowPlayer, Config.options().secondButtonOp);
            TriggerButtonManager.generate(acs, playerRefSlot, true, forceShowPlayer, Config.options().thirdButtonOp);
        }
    }

    private static void generate(AbstractContainerScreen<?> screen, Slot refSlot, boolean isPlayerInv, boolean forceShow, Operation op) {
        switch (op) {
            case SORT: {
                TriggerButtonManager.generateSortButton(screen, refSlot, isPlayerInv, forceShow);
                break;
            }
            case STACK_FILL: {
                TriggerButtonManager.generateStackFillButton(screen, refSlot, isPlayerInv, forceShow);
                break;
            }
            case TRANSFER: {
                TriggerButtonManager.generateTransferButton(screen, refSlot, isPlayerInv, forceShow);
            }
        }
    }

    private static void generateSortButton(AbstractContainerScreen<?> screen, Slot referenceSlot, boolean isPlayerInv, boolean forceShow) {
        Inventory container;
        @Nullable LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (screen instanceof InventoryScreen && !isPlayerInv) {
            return;
        }
        if (TriggerButtonManager.getNumberOfBulkInventorySlots(screen, isPlayerInv) < 3) {
            return;
        }
        Object object = container = isPlayerInv ? player.getInventory() : TriggerButtonManager.getContainer((Player)player);
        if (container == null) {
            return;
        }
        Object object2 = container instanceof SimpleContainer ? screen.getMenu() : container;
        @Nullable ClassPolicy policy = PolicyManager.getPolicy(object2.getClass());
        if (!(policy != null && policy.showSortButton() || forceShow)) {
            return;
        }
        Vec2i offset = policy != null ? policy.getButtonOffset() : Config.options().layoutOffset;
        SortButton button = new SortButton(screen, (Container)container, referenceSlot, isPlayerInv, policy, object2.getClass().getName(), TriggerButtonManager.getShiftedOffset(offset, isPlayerInv));
        TriggerButtonManager.addButton(screen, button, isPlayerInv);
    }

    private static void generateStackFillButton(AbstractContainerScreen<?> screen, Slot referenceSlot, boolean isPlayerInv, boolean forceShow) {
        Container dstObject;
        ClassPolicy dstPolicy;
        Container dstContainer;
        Inventory container;
        @Nullable LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (screen instanceof InventoryScreen && !isPlayerInv) {
            return;
        }
        if (TriggerButtonManager.getNumberOfBulkInventorySlots(screen, isPlayerInv) < 3) {
            return;
        }
        Object object = container = isPlayerInv ? player.getInventory() : TriggerButtonManager.getContainer((Player)player);
        if (container == null) {
            return;
        }
        Object object2 = container instanceof SimpleContainer ? screen.getMenu() : container;
        @Nullable ClassPolicy policy = PolicyManager.getPolicy(object2.getClass());
        if (!(policy != null && policy.showStackFillButton() || forceShow)) {
            return;
        }
        Vec2i offset = policy != null ? policy.getButtonOffset() : Config.options().layoutOffset;
        Object object3 = dstContainer = isPlayerInv ? TriggerButtonManager.getContainer((Player)player) : player.getInventory();
        if (!(dstContainer == null || (dstPolicy = PolicyManager.getPolicy((dstObject = dstContainer instanceof SimpleContainer ? screen.getMenu() : dstContainer).getClass())) != null && dstPolicy.showStackFillButton() || forceShow)) {
            return;
        }
        StackFillButton button = new StackFillButton(screen, (Container)container, referenceSlot, isPlayerInv, policy, object2.getClass().getName(), TriggerButtonManager.getShiftedOffset(offset, isPlayerInv));
        TriggerButtonManager.addButton(screen, button, isPlayerInv);
    }

    private static void generateTransferButton(AbstractContainerScreen<?> screen, Slot referenceSlot, boolean isPlayerInv, boolean forceShow) {
        Container dstObject;
        ClassPolicy dstPolicy;
        Container dstContainer;
        Inventory container;
        @Nullable LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (screen instanceof InventoryScreen && !isPlayerInv) {
            return;
        }
        if (TriggerButtonManager.getNumberOfBulkInventorySlots(screen, isPlayerInv) < 3) {
            return;
        }
        Object object = container = isPlayerInv ? player.getInventory() : TriggerButtonManager.getContainer((Player)player);
        if (container == null) {
            return;
        }
        Object object2 = container instanceof SimpleContainer ? screen.getMenu() : container;
        @Nullable ClassPolicy policy = PolicyManager.getPolicy(object2.getClass());
        if (!(policy != null && policy.showTransferButton() || forceShow)) {
            return;
        }
        Vec2i offset = policy != null ? policy.getButtonOffset() : Config.options().layoutOffset;
        Object object3 = dstContainer = isPlayerInv ? TriggerButtonManager.getContainer((Player)player) : player.getInventory();
        if (!(dstContainer == null || (dstPolicy = PolicyManager.getPolicy((dstObject = dstContainer instanceof SimpleContainer ? screen.getMenu() : dstContainer).getClass())) != null && dstPolicy.showTransferButton() || forceShow)) {
            return;
        }
        TransferButton button = new TransferButton(screen, (Container)container, referenceSlot, isPlayerInv, policy, object2.getClass().getName(), TriggerButtonManager.getShiftedOffset(offset, isPlayerInv));
        TriggerButtonManager.addButton(screen, button, isPlayerInv);
    }

    @Nullable
    public static Container getContainer(Player player) {
        try {
            return player.containerMenu.getSlot((int)0).container;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private static void addButton(AbstractContainerScreen<?> screen, TriggerButton button, boolean isPlayerInv) {
        ((ScreenAccessor)screen).clientsort$addRenderableWidget(button);
        (isPlayerInv ? playerButtons : containerButtons).add(button);
    }

    @Nullable
    private static Slot getReferenceSlot(AbstractContainerScreen<?> screen, boolean isPlayerInv) {
        ContainerScreenHelper<AbstractContainerScreen<?>> helper = ContainerScreenHelper.of(screen);
        return screen.getMenu().slots.stream().filter(slot -> isPlayerInv ? slot.container instanceof Inventory && helper.getScope((Slot)slot).equals((Object)Scope.PLAYER_INV) : !(slot.container instanceof Inventory) && helper.getScope((Slot)slot).equals((Object)Scope.CONTAINER_INV)).max(Comparator.comparingInt(slot -> slot.x * 9999 - slot.y)).orElse(null);
    }

    private static int getNumberOfBulkInventorySlots(AbstractContainerScreen<?> screen, boolean isPlayerInv) {
        return screen.getMenu().slots.stream().filter(slot -> isPlayerInv == slot.container instanceof Inventory).filter(slot -> !(screen.getMenu() instanceof HorseInventoryMenu) || ((ISlot)slot).clientsort$getIndexInInv() >= 2).mapToInt(slot -> 1).sum();
    }

    public static Vec2i getShiftedOffset(Vec2i offset, boolean isPlayerInv) {
        int index = (isPlayerInv ? playerButtons : containerButtons).size();
        int x = offset.x() + 0 * index;
        int y = offset.y() + 14 * index;
        return new Vec2i(x, y);
    }
}

